/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 1 "rp2gen_parser.y"
 /* BLURB gpl

                           Coda File System
                              Release 5

          Copyright (c) 1987-1999 Carnegie Mellon University
                  Additional copyrights listed below

This  code  is  distributed "AS IS" without warranty of any kind under
the terms of the GNU General Public Licence Version 2, as shown in the
file  LICENSE.  The  technical and financial  contributors to Coda are
listed in the file CREDITS.

                        Additional copyrights

#*/

/*
                         IBM COPYRIGHT NOTICE

                          Copyright (C) 1986
             International Business Machines Corporation
                         All Rights Reserved

This  file  contains  some  code identical to or derived from the 1986
version of the Andrew File System ("AFS"), which is owned by  the  IBM
Corporation.   This  code is provided "AS IS" and IBM does not warrant
that it is free of infringement of  any  intellectual  rights  of  any
third  party.    IBM  disclaims  liability of any kind for any damages
whatsoever resulting directly or indirectly from use of this  software
or  of  any  derivative work.  Carnegie Mellon University has obtained
permission to  modify,  distribute and sublicense this code,  which is
based on Version 2  of  AFS  and  does  not  contain  the features and
enhancements that are part of  Version 3 of  AFS.  Version 3 of AFS is
commercially   available   and  supported  by   Transarc  Corporation,
Pittsburgh, PA.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "rp2.h"

extern int yydebug;
extern int HeaderOnlyFlag;

extern char *copy();
extern RPC2_TYPE *rpc2_enum_type(), *rpc2_struct_type();
extern ENTRY *make_entry(), *find();
extern ENUM *make_enum();
extern VAR *make_var();
extern PROC *make_proc(), *check_proc();
extern void enter();
extern char *concat();
extern struct subsystem subsystem;
extern void no_storage(char *);
extern void spit_define(char *, char *);
extern void insert(PROC *proc);

/* Structure for handling IDENTIFIER lists */

#define MAX_IDS	100

struct {
    char	*ids[MAX_IDS];
    int		counter;
} id_list;

static char **make_id_array()
{
    register char **array;
    register int i;

    array = (char **) calloc(id_list.counter+1, sizeof(char *));
    if (array == NIL) no_storage("make_id_array");
    array[id_list.counter] = NIL;
    for (i=0, id_list.counter--; id_list.counter>=0; i++, id_list.counter--)
	array[i] = id_list.ids[id_list.counter];
    return array;
}

#define MAX_ENUMS	100

struct {
    ENUM	*enums[MAX_ENUMS];
    int		counter;
} enum_list;

static ENUM **make_enum_array()
{
    register ENUM **array;
    register int i;

    array = (ENUM **) calloc(enum_list.counter+1, sizeof(ENUM *));
    if (array == NIL) no_storage("make_enum_array");
    array[enum_list.counter] = NIL;
    for (i=0, enum_list.counter--; enum_list.counter>=0; i++, enum_list.counter--)
	array[i] = enum_list.enums[enum_list.counter];
    return array;
}

#define MAX_FORMALS	100

struct {
    VAR		*formals[MAX_FORMALS];
    int		counter;
} formal_list;

static VAR **make_formal_array()
{
    register VAR **array;
    register int i;

    array = (VAR **) calloc(formal_list.counter+1, sizeof(VAR *));
    if (array == NIL) no_storage("make_formal_array");
    array[formal_list.counter] = NIL;
    for (i=0, formal_list.counter--; formal_list.counter>=0; i++, formal_list.counter--)
	array[i] = formal_list.formals[formal_list.counter];
    return array;
}

#define MAX_VARS	100

struct {
    VAR		**vars[MAX_VARS];
    int		counter;
} var_list;

static int length(p)
    char **p;
{
    register int len;

    for (len=0; *p!=NIL; p++) len++;
    return len;
}

static VAR **make_var_array()
{
    register int count, i;
    register VAR **array;

    for (i=0, count=0; i<var_list.counter; i++) count += length((char **)var_list.vars[i]);
    array = (VAR **) calloc(count+1, sizeof(VAR *));
    if (array == NIL) no_storage("make_var_array");
    array[count] = NIL;

    /* Transfer to array */
    for (i=0, var_list.counter--; var_list.counter>=0; var_list.counter--) {
	register VAR **v;
	for (v = var_list.vars[var_list.counter]; *v != NIL; v++)
	    array[i++] = *v;
    }
    return array;
}

static char *createsize(name)
    char *name;
{
    return concat(name, "_size_");
}

static char *createmaxsize(name)
    char *name;
{
    return concat(name, "_size_max_");
}

int next_opnum = 1;


#line 244 "rp2gen_parser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_YY_RP_GEN_PARSER_H_INCLUDED
# define YY_YY_RP_GEN_PARSER_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    IDENTIFIER = 258,              /* IDENTIFIER  */
    NUMBER = 259,                  /* NUMBER  */
    STRING = 260,                  /* STRING  */
    SUBSYSTEM = 261,               /* SUBSYSTEM  */
    TIMEOUT = 262,                 /* TIMEOUT  */
    DEFINE = 263,                  /* DEFINE  */
    NEW_CONNECTION = 264,          /* NEW_CONNECTION  */
    TYPEDEF = 265,                 /* TYPEDEF  */
    RPC2_STRUCT = 266,             /* RPC2_STRUCT  */
    RPC2_ENUM = 267,               /* RPC2_ENUM  */
    CLIENT = 268,                  /* CLIENT  */
    SERVER = 269,                  /* SERVER  */
    PREFIX = 270,                  /* PREFIX  */
    IN = 271,                      /* IN  */
    OUT = 272                      /* OUT  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define IDENTIFIER 258
#define NUMBER 259
#define STRING 260
#define SUBSYSTEM 261
#define TIMEOUT 262
#define DEFINE 263
#define NEW_CONNECTION 264
#define TYPEDEF 265
#define RPC2_STRUCT 266
#define RPC2_ENUM 267
#define CLIENT 268
#define SERVER 269
#define PREFIX 270
#define IN 271
#define OUT 272

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 187 "rp2gen_parser.y"

    rp2_bool	u_bool;
    MODE	u_mode;
    char	*u_string;
    char	**u_string_array;
    RPC2_TYPE	*u_rpc2_type;
    ENTRY	*u_entry;
    ENUM	*u_enum;
    VAR		*u_var;
    VAR		**u_var_array;
    VAR		***u_var_array_array;
    int         u_int;

#line 345 "rp2gen_parser.c"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;


int yyparse (void);


#endif /* !YY_YY_RP_GEN_PARSER_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_IDENTIFIER = 3,                 /* IDENTIFIER  */
  YYSYMBOL_NUMBER = 4,                     /* NUMBER  */
  YYSYMBOL_STRING = 5,                     /* STRING  */
  YYSYMBOL_SUBSYSTEM = 6,                  /* SUBSYSTEM  */
  YYSYMBOL_TIMEOUT = 7,                    /* TIMEOUT  */
  YYSYMBOL_DEFINE = 8,                     /* DEFINE  */
  YYSYMBOL_NEW_CONNECTION = 9,             /* NEW_CONNECTION  */
  YYSYMBOL_TYPEDEF = 10,                   /* TYPEDEF  */
  YYSYMBOL_RPC2_STRUCT = 11,               /* RPC2_STRUCT  */
  YYSYMBOL_RPC2_ENUM = 12,                 /* RPC2_ENUM  */
  YYSYMBOL_CLIENT = 13,                    /* CLIENT  */
  YYSYMBOL_SERVER = 14,                    /* SERVER  */
  YYSYMBOL_PREFIX = 15,                    /* PREFIX  */
  YYSYMBOL_IN = 16,                        /* IN  */
  YYSYMBOL_OUT = 17,                       /* OUT  */
  YYSYMBOL_18_ = 18,                       /* ';'  */
  YYSYMBOL_19_ = 19,                       /* '('  */
  YYSYMBOL_20_ = 20,                       /* ')'  */
  YYSYMBOL_21_ = 21,                       /* '{'  */
  YYSYMBOL_22_ = 22,                       /* '}'  */
  YYSYMBOL_23_ = 23,                       /* ','  */
  YYSYMBOL_24_ = 24,                       /* '='  */
  YYSYMBOL_25_ = 25,                       /* '['  */
  YYSYMBOL_26_ = 26,                       /* ']'  */
  YYSYMBOL_27_ = 27,                       /* ':'  */
  YYSYMBOL_YYACCEPT = 28,                  /* $accept  */
  YYSYMBOL_file = 29,                      /* file  */
  YYSYMBOL_prefixes = 30,                  /* prefixes  */
  YYSYMBOL_prefix = 31,                    /* prefix  */
  YYSYMBOL_header_line = 32,               /* header_line  */
  YYSYMBOL_compatibility_stuff = 33,       /* compatibility_stuff  */
  YYSYMBOL_subsystem_name = 34,            /* subsystem_name  */
  YYSYMBOL_id_number = 35,                 /* id_number  */
  YYSYMBOL_protocol_version = 36,          /* protocol_version  */
  YYSYMBOL_default_timeout = 37,           /* default_timeout  */
  YYSYMBOL_decl_or_proc_list = 38,         /* decl_or_proc_list  */
  YYSYMBOL_decl_or_proc = 39,              /* decl_or_proc  */
  YYSYMBOL_define = 40,                    /* define  */
  YYSYMBOL_typedef = 41,                   /* typedef  */
  YYSYMBOL_rpc2_type = 42,                 /* rpc2_type  */
  YYSYMBOL_type_name = 43,                 /* type_name  */
  YYSYMBOL_rpc2_struct = 44,               /* rpc2_struct  */
  YYSYMBOL_field_list = 45,                /* field_list  */
  YYSYMBOL_field = 46,                     /* field  */
  YYSYMBOL_identifier_list = 47,           /* identifier_list  */
  YYSYMBOL_identifier_list2 = 48,          /* identifier_list2  */
  YYSYMBOL_rpc2_enum = 49,                 /* rpc2_enum  */
  YYSYMBOL_enum_val_list = 50,             /* enum_val_list  */
  YYSYMBOL_enum_val = 51,                  /* enum_val  */
  YYSYMBOL_array_spec = 52,                /* array_spec  */
  YYSYMBOL_array_spec_var = 53,            /* array_spec_var  */
  YYSYMBOL_procedure_description = 54,     /* procedure_description  */
  YYSYMBOL_opcode_number = 55,             /* opcode_number  */
  YYSYMBOL_formal_list = 56,               /* formal_list  */
  YYSYMBOL_formal = 57,                    /* formal  */
  YYSYMBOL_usage = 58,                     /* usage  */
  YYSYMBOL_timeout_override = 59,          /* timeout_override  */
  YYSYMBOL_new_connection = 60,            /* new_connection  */
  YYSYMBOL_DefinedNumber = 61,             /* DefinedNumber  */
  YYSYMBOL_String = 62,                    /* String  */
  YYSYMBOL_empty = 63                      /* empty  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  9
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   101

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  28
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  36
/* YYNRULES -- Number of rules.  */
#define YYNRULES  61
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  115

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   272


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      19,    20,     2,     2,    23,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    27,    18,
       2,    24,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    25,     2,    26,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    21,     2,    22,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   227,   227,   230,   231,   232,   235,   241,   249,   254,
     261,   263,   266,   270,   274,   278,   280,   284,   285,   288,
     289,   290,   294,   296,   300,   315,   317,   319,   323,   333,
     337,   345,   352,   365,   369,   377,   384,   388,   396,   403,
     407,   409,   413,   417,   421,   434,   437,   442,   470,   493,
     497,   503,   505,   507,   511,   513,   517,   519,   523,   525,
     529,   537
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "IDENTIFIER", "NUMBER",
  "STRING", "SUBSYSTEM", "TIMEOUT", "DEFINE", "NEW_CONNECTION", "TYPEDEF",
  "RPC2_STRUCT", "RPC2_ENUM", "CLIENT", "SERVER", "PREFIX", "IN", "OUT",
  "';'", "'('", "')'", "'{'", "'}'", "','", "'='", "'['", "']'", "':'",
  "$accept", "file", "prefixes", "prefix", "header_line",
  "compatibility_stuff", "subsystem_name", "id_number", "protocol_version",
  "default_timeout", "decl_or_proc_list", "decl_or_proc", "define",
  "typedef", "rpc2_type", "type_name", "rpc2_struct", "field_list",
  "field", "identifier_list", "identifier_list2", "rpc2_enum",
  "enum_val_list", "enum_val", "array_spec", "array_spec_var",
  "procedure_description", "opcode_number", "formal_list", "formal",
  "usage", "timeout_override", "new_connection", "DefinedNumber", "String",
  "empty", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-34)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-62)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int8 yypact[] =
{
      -5,    -1,    13,    24,    23,    -5,   -34,     5,     5,   -34,
       5,    25,   -34,   -34,   -34,    12,    16,     9,   -34,    14,
     -34,   -34,   -34,   -34,   -34,   -34,    18,     9,   -34,   -34,
       9,    15,   -34,   -34,   -34,   -34,    19,     8,    34,     4,
     -34,   -34,   -34,   -34,    35,   -34,    22,   -34,    17,   -34,
      21,    26,    40,   -34,   -34,   -34,    27,   -34,   -34,   -34,
      45,    46,    28,    10,    47,    29,    45,    30,    33,    36,
       9,    38,   -34,    41,   -34,    32,    39,    45,   -34,    37,
      43,   -34,   -34,   -34,    53,   -34,    46,    42,   -34,   -34,
      56,    44,    48,   -34,    62,    47,   -34,   -34,   -34,   -34,
      50,    57,   -34,   -34,    10,   -34,   -34,     9,   -34,    49,
     -34,   -34,    52,   -34,   -34
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
      61,     0,     0,     0,    61,     4,     3,     0,     0,     1,
       0,    61,     9,     5,    60,     0,     0,    61,    12,     0,
      61,    16,     7,     6,    59,    58,     0,     0,    13,    11,
       0,     2,    18,     8,    10,    14,     0,     0,     0,     0,
      17,    20,    19,    21,     0,    46,     0,    45,     0,    28,
       0,     0,     0,    25,    26,    27,     0,    15,    22,    23,
       0,     0,    61,    61,     0,     0,    31,     0,     0,    38,
       0,     0,    41,    51,    52,     0,    61,     0,    49,    35,
       0,    33,    29,    30,     0,    36,     0,     0,    24,    53,
      61,     0,    48,    43,     0,     0,    32,    39,    37,    40,
       0,    61,    55,    42,    61,    50,    34,     0,    56,     0,
      57,    47,     0,    44,    54
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -34,   -34,   -34,    68,   -34,   -34,   -34,   -34,   -34,   -34,
     -34,   -34,   -34,   -34,   -34,   -33,   -34,    11,   -34,   -34,
     -21,   -34,   -11,   -34,   -34,   -34,   -34,   -34,   -26,   -34,
     -34,   -34,   -34,   -25,    -7,     0
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
       0,     3,     4,     5,    11,    26,    17,    27,    34,    20,
      31,    40,    41,    42,    52,    64,    54,    65,    66,    80,
      81,    55,    68,    69,    71,    92,    43,    44,    75,    76,
      77,   101,   109,    28,    15,    78
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int8 yytable[] =
{
       6,    16,    35,    18,    12,    36,    53,    49,     1,     2,
      14,    21,    24,    25,     7,    50,    51,    29,   -61,    37,
      32,    58,    14,    38,     9,    39,    73,    74,     8,    10,
      22,    45,    19,    30,    23,    47,    33,    48,    56,    46,
      57,    59,    60,    62,    94,    87,    63,    61,    49,    67,
      79,    82,    90,    70,    84,    85,    88,    97,    89,    86,
      95,    96,    72,   100,    91,   105,   108,   113,    99,   107,
     103,   104,   114,    13,   106,    98,    93,    83,   111,     0,
       0,     0,   112,     0,     0,     0,     0,     0,     0,     0,
     102,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   110
};

static const yytype_int8 yycheck[] =
{
       0,     8,    27,    10,     4,    30,    39,     3,    13,    14,
       5,    11,     3,     4,    15,    11,    12,    17,     3,     4,
      20,     4,     5,     8,     0,    10,    16,    17,    15,     6,
      18,    31,     7,    19,    18,    27,    18,     3,     3,    20,
      18,    48,    21,     3,    77,    70,    19,    21,     3,     3,
       3,    22,    20,    25,    24,    22,    18,     4,    17,    23,
      23,    18,    62,     7,    25,     3,     9,    18,    26,    19,
      26,    23,    20,     5,    95,    86,    76,    66,   104,    -1,
      -1,    -1,   107,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   101
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,    13,    14,    29,    30,    31,    63,    15,    15,     0,
       6,    32,    63,    31,     5,    62,    62,    34,    62,     7,
      37,    63,    18,    18,     3,     4,    33,    35,    61,    63,
      19,    38,    63,    18,    36,    61,    61,     4,     8,    10,
      39,    40,    41,    54,    55,    63,    20,    27,     3,     3,
      11,    12,    42,    43,    44,    49,     3,    18,     4,    62,
      21,    21,     3,    19,    43,    45,    46,     3,    50,    51,
      25,    52,    63,    16,    17,    56,    57,    58,    63,     3,
      47,    48,    22,    45,    24,    22,    23,    61,    18,    17,
      20,    25,    53,    63,    43,    23,    18,     4,    50,    26,
       7,    59,    63,    26,    23,     3,    48,    19,     9,    60,
      63,    56,    61,    18,    20
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    28,    29,    30,    30,    30,    31,    31,    32,    32,
      33,    33,    34,    35,    36,    37,    37,    38,    38,    39,
      39,    39,    40,    40,    41,    42,    42,    42,    43,    44,
      45,    45,    46,    47,    48,    48,    49,    50,    50,    51,
      52,    52,    53,    53,    54,    55,    55,    56,    56,    56,
      57,    58,    58,    58,    59,    59,    60,    60,    61,    61,
      62,    63
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     4,     1,     1,     2,     4,     4,     4,     1,
       2,     1,     1,     1,     1,     5,     1,     2,     1,     1,
       1,     1,     3,     3,     5,     1,     1,     1,     1,     4,
       2,     1,     3,     1,     3,     1,     4,     3,     1,     3,
       3,     1,     2,     1,     8,     2,     1,     4,     2,     1,
       3,     1,     1,     2,     4,     1,     1,     1,     1,     1,
       1,     0
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 6: /* prefix: SERVER PREFIX String ';'  */
#line 236 "rp2gen_parser.y"
                                        {
					    extern char *server_prefix;
					    server_prefix = copy((yyvsp[-1].u_string)+1);
					    server_prefix[strlen(server_prefix)-1] = '\0';
					}
#line 1467 "rp2gen_parser.c"
    break;

  case 7: /* prefix: CLIENT PREFIX String ';'  */
#line 242 "rp2gen_parser.y"
                                        {
					    extern char *client_prefix;
					    client_prefix = copy((yyvsp[-1].u_string)+1);
					    client_prefix[strlen(client_prefix)-1] = '\0';
					}
#line 1477 "rp2gen_parser.c"
    break;

  case 8: /* header_line: SUBSYSTEM subsystem_name compatibility_stuff ';'  */
#line 250 "rp2gen_parser.y"
                                        {
					    subsystem.subsystem_name = copy((yyvsp[-2].u_string)+1);
					    subsystem.subsystem_name[strlen(subsystem.subsystem_name)-1] = '\0';
					}
#line 1486 "rp2gen_parser.c"
    break;

  case 9: /* header_line: empty  */
#line 255 "rp2gen_parser.y"
                            {
			    printf("NO SUBSYSTEM SPECIFIED: only generating header file\n");
			    HeaderOnlyFlag = 1;
			    }
#line 1495 "rp2gen_parser.c"
    break;

  case 10: /* compatibility_stuff: id_number protocol_version  */
#line 262 "rp2gen_parser.y"
                                        {}
#line 1501 "rp2gen_parser.c"
    break;

  case 12: /* subsystem_name: String  */
#line 267 "rp2gen_parser.y"
                                        { (yyval.u_string) = (yyvsp[0].u_string); }
#line 1507 "rp2gen_parser.c"
    break;

  case 13: /* id_number: DefinedNumber  */
#line 271 "rp2gen_parser.y"
                                        { (yyval.u_string) = (yyvsp[0].u_string); }
#line 1513 "rp2gen_parser.c"
    break;

  case 14: /* protocol_version: DefinedNumber  */
#line 275 "rp2gen_parser.y"
                                        { (yyval.u_string) = (yyvsp[0].u_string); }
#line 1519 "rp2gen_parser.c"
    break;

  case 15: /* default_timeout: TIMEOUT '(' DefinedNumber ')' ';'  */
#line 279 "rp2gen_parser.y"
                                        { subsystem.timeout = (yyvsp[-2].u_string); }
#line 1525 "rp2gen_parser.c"
    break;

  case 16: /* default_timeout: empty  */
#line 281 "rp2gen_parser.y"
                                        { subsystem.timeout = NIL; }
#line 1531 "rp2gen_parser.c"
    break;

  case 21: /* decl_or_proc: procedure_description  */
#line 291 "rp2gen_parser.y"
                                        {}
#line 1537 "rp2gen_parser.c"
    break;

  case 22: /* define: DEFINE IDENTIFIER NUMBER  */
#line 295 "rp2gen_parser.y"
                                        { if ((yyvsp[-2].u_bool)) spit_define((yyvsp[-1].u_string), (yyvsp[0].u_string)); }
#line 1543 "rp2gen_parser.c"
    break;

  case 23: /* define: DEFINE IDENTIFIER String  */
#line 297 "rp2gen_parser.y"
                                        { if ((yyvsp[-2].u_bool)) spit_define((yyvsp[-1].u_string), (yyvsp[0].u_string)); }
#line 1549 "rp2gen_parser.c"
    break;

  case 24: /* typedef: TYPEDEF rpc2_type IDENTIFIER array_spec ';'  */
#line 301 "rp2gen_parser.y"
                                        {
					    extern void spit_type();
					    (yyvsp[-3].u_entry) -> name = (yyvsp[-2].u_string);
					    (yyvsp[-3].u_entry) -> bound = (yyvsp[-1].u_string);
					    if ((yyvsp[-3].u_entry)->bound != NIL && (yyvsp[-3].u_entry)->type->tag != RPC2_BYTE_TAG) {
						printf("RP2GEN: array type unimplemented: %s\n",
						       (yyvsp[-2].u_string));
						exit(EXIT_FAILURE);
					    }
					    enter((yyvsp[-3].u_entry));
					    if ((yyvsp[-4].u_bool)) spit_type((yyvsp[-3].u_entry));
					}
#line 1566 "rp2gen_parser.c"
    break;

  case 25: /* rpc2_type: type_name  */
#line 316 "rp2gen_parser.y"
                                        { (yyval.u_entry) = make_entry((yyvsp[0].u_entry)->type, (yyvsp[0].u_entry)); }
#line 1572 "rp2gen_parser.c"
    break;

  case 26: /* rpc2_type: rpc2_struct  */
#line 318 "rp2gen_parser.y"
                                        { (yyval.u_entry) = make_entry((yyvsp[0].u_rpc2_type), NIL); }
#line 1578 "rp2gen_parser.c"
    break;

  case 27: /* rpc2_type: rpc2_enum  */
#line 320 "rp2gen_parser.y"
                                        { (yyval.u_entry) = make_entry((yyvsp[0].u_rpc2_type), NIL); }
#line 1584 "rp2gen_parser.c"
    break;

  case 28: /* type_name: IDENTIFIER  */
#line 324 "rp2gen_parser.y"
                                        {
					    (yyval.u_entry) = find((yyvsp[0].u_string));
					    if ((yyval.u_entry) == NIL) {
						printf("RP2GEN: can't find type: %s\n", (yyvsp[0].u_string));
						exit(EXIT_FAILURE);
					    }
					}
#line 1596 "rp2gen_parser.c"
    break;

  case 29: /* rpc2_struct: RPC2_STRUCT '{' field_list '}'  */
#line 334 "rp2gen_parser.y"
                                        { (yyval.u_rpc2_type) = rpc2_struct_type(make_var_array()); }
#line 1602 "rp2gen_parser.c"
    break;

  case 30: /* field_list: field field_list  */
#line 338 "rp2gen_parser.y"
                                        {
					    if (var_list.counter >= MAX_VARS) {
						printf("RP2GEN: too many fields: %d\n", MAX_VARS);
						exit(EXIT_FAILURE);
					    }
					    var_list.vars[var_list.counter++] = (yyvsp[-1].u_var_array);
					}
#line 1614 "rp2gen_parser.c"
    break;

  case 31: /* field_list: field  */
#line 346 "rp2gen_parser.y"
                                        {
					    var_list.vars[0] = (yyvsp[0].u_var_array);
					    var_list.counter = 1;
					}
#line 1623 "rp2gen_parser.c"
    break;

  case 32: /* field: type_name identifier_list ';'  */
#line 353 "rp2gen_parser.y"
                                        {
					    register char **id;
					    register VAR **p;
					    (yyval.u_var_array) = (VAR **) calloc(length((yyvsp[-1].u_string_array))+1, sizeof(VAR *));
					    if ((yyval.u_var_array) == NIL) no_storage("field");
					    for (id=(yyvsp[-1].u_string_array), p=(yyval.u_var_array); *id!=NIL; id++, p++)
						*p = make_var(*id, NO_MODE, (yyvsp[-2].u_entry));
					    *p = NIL;
					    free((yyvsp[-1].u_string_array));
					}
#line 1638 "rp2gen_parser.c"
    break;

  case 33: /* identifier_list: identifier_list2  */
#line 366 "rp2gen_parser.y"
                                        { (yyval.u_string_array) = make_id_array(); }
#line 1644 "rp2gen_parser.c"
    break;

  case 34: /* identifier_list2: IDENTIFIER ',' identifier_list2  */
#line 370 "rp2gen_parser.y"
                                        {
					    if (id_list.counter >= MAX_IDS) {
						printf("RP2GEN: too many identifiers in list: %d\n", MAX_IDS);
						exit(EXIT_FAILURE);
					    }
					    id_list.ids[id_list.counter++] = (yyvsp[-2].u_string);
					}
#line 1656 "rp2gen_parser.c"
    break;

  case 35: /* identifier_list2: IDENTIFIER  */
#line 378 "rp2gen_parser.y"
                                        {
					    id_list.ids[0] = (yyvsp[0].u_string);
					    id_list.counter = 1;
					}
#line 1665 "rp2gen_parser.c"
    break;

  case 36: /* rpc2_enum: RPC2_ENUM '{' enum_val_list '}'  */
#line 385 "rp2gen_parser.y"
                                        { (yyval.u_rpc2_type) = rpc2_enum_type(make_enum_array()); }
#line 1671 "rp2gen_parser.c"
    break;

  case 37: /* enum_val_list: enum_val ',' enum_val_list  */
#line 389 "rp2gen_parser.y"
                                        {
					    if (enum_list.counter >= MAX_ENUMS) {
						printf("RP2GEN: too many enum values: %d\n", MAX_ENUMS);
						exit(EXIT_FAILURE);
					    }
					    enum_list.enums[enum_list.counter++] = (yyvsp[-2].u_enum);
					}
#line 1683 "rp2gen_parser.c"
    break;

  case 38: /* enum_val_list: enum_val  */
#line 397 "rp2gen_parser.y"
                                        {
					    enum_list.enums[0] = (yyvsp[0].u_enum);
					    enum_list.counter = 1;
					}
#line 1692 "rp2gen_parser.c"
    break;

  case 39: /* enum_val: IDENTIFIER '=' NUMBER  */
#line 404 "rp2gen_parser.y"
                                        { (yyval.u_enum) = make_enum((yyvsp[-2].u_string), (yyvsp[0].u_string)); }
#line 1698 "rp2gen_parser.c"
    break;

  case 40: /* array_spec: '[' DefinedNumber ']'  */
#line 408 "rp2gen_parser.y"
                                        { (yyval.u_string) = (yyvsp[-1].u_string); }
#line 1704 "rp2gen_parser.c"
    break;

  case 41: /* array_spec: empty  */
#line 410 "rp2gen_parser.y"
                                        { (yyval.u_string) = NIL; }
#line 1710 "rp2gen_parser.c"
    break;

  case 42: /* array_spec_var: '[' ']'  */
#line 414 "rp2gen_parser.y"
                                        {
					    (yyval.u_var) = make_var(NIL, NO_MODE, find("RPC2_Unsigned"));
					}
#line 1718 "rp2gen_parser.c"
    break;

  case 43: /* array_spec_var: empty  */
#line 418 "rp2gen_parser.y"
                                        { (yyval.u_var) = NIL; }
#line 1724 "rp2gen_parser.c"
    break;

  case 44: /* procedure_description: opcode_number IDENTIFIER '(' formal_list ')' timeout_override new_connection ';'  */
#line 422 "rp2gen_parser.y"
                                        { if ((yyvsp[-1].u_bool) == RP2_FALSE) {
                                            if ((yyvsp[-7].u_int) == -1)
                                                (yyvsp[-7].u_int) = next_opnum;
                                            if ((yyvsp[-7].u_int) < next_opnum) {
                                              printf("RP2GEN: Opcode numbers must be always increasing\n");
                                              exit(EXIT_FAILURE);
                                            }
                                            next_opnum = (yyvsp[-7].u_int) + 1;
                                          }
					  insert(check_proc(make_proc((yyvsp[-7].u_int), (yyvsp[-6].u_string), make_formal_array(), (yyvsp[-2].u_string), (yyvsp[-1].u_bool)))); }
#line 1739 "rp2gen_parser.c"
    break;

  case 45: /* opcode_number: NUMBER ':'  */
#line 435 "rp2gen_parser.y"
                                        { (yyval.u_int) = atoi((yyvsp[-1].u_string)); }
#line 1745 "rp2gen_parser.c"
    break;

  case 46: /* opcode_number: empty  */
#line 438 "rp2gen_parser.y"
                                        { (yyval.u_int) = -1; }
#line 1751 "rp2gen_parser.c"
    break;

  case 47: /* formal_list: formal array_spec_var ',' formal_list  */
#line 443 "rp2gen_parser.y"
                                        {
					    VAR *maxvarp;
					    if (formal_list.counter >= MAX_FORMALS) {
						printf("RP2GEN: too many formals: %d\n", MAX_FORMALS);
						exit(EXIT_FAILURE);
					    }
					    formal_list.formals[formal_list.counter++] = (yyvsp[-3].u_var);
					    if ((yyvsp[-2].u_var) != NIL) {
						if (formal_list.counter >= MAX_FORMALS) {
						    printf("RP2GEN: too many formals: %d\n", MAX_FORMALS);
						    exit(EXIT_FAILURE);
						}
					        if ((yyvsp[-3].u_var)->type->type->tag != RPC2_STRUCT_TAG) {
						    printf("RP2GEN: array type unimplemented: %s\n", (yyvsp[-3].u_var)->name);
						    exit(EXIT_FAILURE);
					        }
					        formal_list.formals[formal_list.counter++] = (yyvsp[-2].u_var);
						(yyvsp[-3].u_var)->array = (yyvsp[-2].u_var)->name = createsize((yyvsp[-3].u_var)->name);
						(yyvsp[-2].u_var)->mode = (yyvsp[-3].u_var)->mode;
						if ((yyvsp[-3].u_var)->mode != IN_MODE) {
						    maxvarp = make_var(NIL, NO_MODE, find("RPC2_Unsigned"));
						    (yyvsp[-3].u_var)->arraymax = maxvarp->name = createmaxsize((yyvsp[-3].u_var)->name);
						    maxvarp->mode = MAX_BOUND;
						    formal_list.formals[formal_list.counter++] = maxvarp;
						}
					    }
					}
#line 1783 "rp2gen_parser.c"
    break;

  case 48: /* formal_list: formal array_spec_var  */
#line 471 "rp2gen_parser.y"
                                        {
					    VAR *maxvarp;
					    formal_list.formals[0] = (yyvsp[-1].u_var);
					    formal_list.counter = 1;
					    if ((yyvsp[0].u_var) != NIL) {
					        if ((yyvsp[-1].u_var)->type->type->tag != RPC2_STRUCT_TAG) {
						    printf("RP2GEN: array type unimplemented: %s\n",
						           (yyvsp[-1].u_var)->name);
						    exit(EXIT_FAILURE);
					        }
					        formal_list.formals[formal_list.counter++] = (yyvsp[0].u_var);
						(yyvsp[-1].u_var)->array = (yyvsp[0].u_var)->name = createsize((yyvsp[-1].u_var)->name);
						(yyvsp[0].u_var)->mode = (yyvsp[-1].u_var)->mode;
						if ((yyvsp[-1].u_var)->mode != IN_MODE) {
						    maxvarp = make_var(NIL, NO_MODE, find("RPC2_Unsigned"));
						    (yyvsp[-1].u_var)->arraymax = maxvarp->name = createmaxsize((yyvsp[-1].u_var)->name);
						    maxvarp->mode = IN_MODE;
						    formal_list.formals[formal_list.counter++] = maxvarp;
						}
					    }

					}
#line 1810 "rp2gen_parser.c"
    break;

  case 49: /* formal_list: empty  */
#line 494 "rp2gen_parser.y"
                                        { formal_list.counter = 0; }
#line 1816 "rp2gen_parser.c"
    break;

  case 50: /* formal: usage type_name IDENTIFIER  */
#line 498 "rp2gen_parser.y"
                                        {
					  (yyval.u_var) = make_var((yyvsp[0].u_string), (yyvsp[-2].u_mode), (yyvsp[-1].u_entry));
					}
#line 1824 "rp2gen_parser.c"
    break;

  case 51: /* usage: IN  */
#line 504 "rp2gen_parser.y"
                                        { (yyval.u_mode) = IN_MODE; }
#line 1830 "rp2gen_parser.c"
    break;

  case 52: /* usage: OUT  */
#line 506 "rp2gen_parser.y"
                                        { (yyval.u_mode) = OUT_MODE; }
#line 1836 "rp2gen_parser.c"
    break;

  case 53: /* usage: IN OUT  */
#line 508 "rp2gen_parser.y"
                                        { (yyval.u_mode) = IN_OUT_MODE; }
#line 1842 "rp2gen_parser.c"
    break;

  case 54: /* timeout_override: TIMEOUT '(' DefinedNumber ')'  */
#line 512 "rp2gen_parser.y"
                                        { (yyval.u_string) = (yyvsp[-1].u_string); }
#line 1848 "rp2gen_parser.c"
    break;

  case 55: /* timeout_override: empty  */
#line 514 "rp2gen_parser.y"
                                        { (yyval.u_string) = NIL; }
#line 1854 "rp2gen_parser.c"
    break;

  case 56: /* new_connection: NEW_CONNECTION  */
#line 518 "rp2gen_parser.y"
                                        { (yyval.u_bool) = RP2_TRUE; }
#line 1860 "rp2gen_parser.c"
    break;

  case 57: /* new_connection: empty  */
#line 520 "rp2gen_parser.y"
                                        { (yyval.u_bool) = RP2_FALSE; }
#line 1866 "rp2gen_parser.c"
    break;

  case 58: /* DefinedNumber: NUMBER  */
#line 524 "rp2gen_parser.y"
                                        { (yyval.u_string) = (yyvsp[0].u_string); }
#line 1872 "rp2gen_parser.c"
    break;

  case 59: /* DefinedNumber: IDENTIFIER  */
#line 526 "rp2gen_parser.y"
                                        { (yyval.u_string) = (yyvsp[0].u_string); }
#line 1878 "rp2gen_parser.c"
    break;

  case 60: /* String: STRING  */
#line 530 "rp2gen_parser.y"
                                        { (yyval.u_string) = (yyvsp[0].u_string); }
#line 1884 "rp2gen_parser.c"
    break;


#line 1888 "rp2gen_parser.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 539 "rp2gen_parser.y"

